from django.db import models

from staff.person.models import Staff

from staff.map.models import Office


class OfficeNet(models.Model):
    office = models.ForeignKey(Office, null=True, blank=True)
    name = models.CharField(max_length=255)
    net = models.CharField(max_length=50)
    first_ip_value = models.DecimalField(max_digits=40, decimal_places=0, blank=True, null=True)
    last_ip_value = models.DecimalField(max_digits=40, decimal_places=0, blank=True, null=True)

    def __str__(self):
        return '%s: %s' % (str(self.office), self.net)


class StaffLastOffice(models.Model):
    staff = models.OneToOneField(Staff)
    office = models.ForeignKey(Office, null=True)
    office_name = models.CharField(max_length=255, default='')
    office_name_en = models.CharField(max_length=255, default='')
    is_vpn = models.BooleanField(default=False)
    updated_at = models.DateTimeField()

    def __str__(self):
        where = 'nowhere'
        if self.office:
            where = str(self.office)
        elif self.is_vpn:
            where = 'VPN'

        return f'{self.staff} was in {where} at {self.updated_at}'


class NOCOffice(models.Model):
    noc_office_id = models.IntegerField(primary_key=True, verbose_name='NOC\'s office id')
    office = models.ForeignKey(Office, blank=True, null=True, default=None, verbose_name='Staff office id')
    is_vpn = models.BooleanField(default=False, verbose_name='Is VPN')

    def __str__(self):
        office_id = self.office_id or 'VPN'
        return 'NOC [%s] -> Staff [%s]' % (self.noc_office_id, office_id)

    class Meta:
        permissions = [
            ('can_export_nocoffice_mapping', 'Can export nocoffice mapping'),
        ]
