from django.contrib import admin

from staff.lib.utils.admin import BaseIntranetAdmin

from staff.workspace_management.models import BusinessUnit, OfficeArea


class BusinessUnitAdmin(BaseIntranetAdmin):
    list_display = ('id', 'organization', 'name', 'name_en', 'intranet_status')


class OfficeAreaAdmin(BaseIntranetAdmin):
    list_display = ('id', 'office', 'from_date', 'to_date', 'office_area')
    ordering = ('office', 'to_date')


admin.site.register(BusinessUnit, BusinessUnitAdmin)
admin.site.register(OfficeArea, OfficeAreaAdmin)
