from abc import ABCMeta, abstractmethod
from datetime import date
from typing import Optional, List

from staff.workspace_management.entities.share_pie import RoomSharePie


class Repository(metaclass=ABCMeta):
    @abstractmethod
    def save_share_pie(self, share_pie: RoomSharePie) -> None:
        pass

    @abstractmethod
    def last_share_pie_for_room(self, room_id: int) -> Optional[RoomSharePie]:
        pass

    @abstractmethod
    def share_pie_for_room_and_date(self, room_id: int, current_date: date) -> Optional[RoomSharePie]:
        pass

    @abstractmethod
    def share_pies_for_rooms_and_date(self, room_ids: List[int], current_date: date) -> List[RoomSharePie]:
        pass
