from decimal import Decimal
from datetime import date
from typing import List
from uuid import UUID

import attr


@attr.s(auto_attribs=True)
class Share:
    share_value: Decimal
    business_unit_id: int


@attr.s(auto_attribs=True)
class RoomSharePie:
    room_share_pie_id: UUID
    room_id: int
    author_id: int
    from_date: date
    to_date: date
    room_area: Decimal
    shares: List[Share]
