# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0014_remove_staff_passwd_set_at'),
        ('workspace_management', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='RoomSharePie',
            fields=[
                ('id', models.UUIDField(primary_key=True, default=uuid.uuid1, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('from_date', models.DateField()),
                ('to_date', models.DateField()),
                ('room_area', models.DecimalField(max_digits=12, decimal_places=4)),
                ('author', models.ForeignKey(to='django_intranet_stuff.Staff')),
                ('room', models.ForeignKey(related_name='pies', to='django_intranet_stuff.Room')),
            ],
        ),
        migrations.CreateModel(
            name='Share',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('share_value', models.DecimalField(max_digits=7, decimal_places=4)),
                ('business_unit', models.ForeignKey(related_name='+', to='workspace_management.BusinessUnit')),
                ('room_share_pie', models.ForeignKey(related_name='shares', to='workspace_management.RoomSharePie')),
            ],
        ),
    ]
