from typing import Iterable

from staff.lib import xlsx

from staff.workspace_management.usage_report.bc_usage_model import BCUsageModelRow


class BCUsageReportPresenter(xlsx.SheetPresenter):
    sheet_name = 'BC usage report'
    _model: Iterable[BCUsageModelRow]
    _headings = (
        'БЦ',
        'Арендуемая площадь, кв.м',
        'Рабочая площадь, кв.м',
        'Площадь общего пользования, кв.м',
        'Рабочая площадь под БЮ, кв.м',
        'Свободный резерв, кв.м',
    )

    def __init__(self, model: Iterable[BCUsageModelRow]):
        super().__init__(model)

    def columns(self) -> Iterable[xlsx.Column]:
        return self.auto_columns()

    def column_captions_row(self) -> xlsx.ViewRow:
        return xlsx.ViewRow(
            xlsx.ViewCell(heading_text, {'bg_color': '#D3D3D3'})
            for heading_text in self._headings
        )

    def rows(self) -> Iterable[xlsx.ViewRow]:
        yield self.column_captions_row()
        for model_row in self._model:
            yield self.default_view_row_from_row_data([
                f'{model_row.office_name} / {model_row.office_name_en}',
                model_row.bc_rent_area,
                model_row.work_area,
                model_row.public_area,
                model_row.bu_work_area,
                model_row.free_area,
            ])
