from typing import Iterable

from staff.lib import xlsx

from staff.workspace_management.usage_report.bu_usage_model import BUUsageModelRow


class BUUsageReportPresenter(xlsx.SheetPresenter):
    sheet_name = 'BU usage report'
    _model: Iterable[BUUsageModelRow]
    _headings = (
        'БЦ',
        'БЮ',
        'Рабочая площадь под БЮ, кв.м',
        'Рабочая площадь под БЮ, %',
        'Площадь общего пользования под БЮ, кв.м',
        'Итого площадь под БЮ, кв.м',
    )

    def __init__(self, model: Iterable[BUUsageModelRow]):
        super().__init__(model)

    def columns(self) -> Iterable[xlsx.Column]:
        return self.auto_columns()

    def rows(self) -> Iterable[xlsx.ViewRow]:
        yield self.column_captions_row()
        for model_row in self._model:
            row_data = (
                f'{model_row.office_name} / {model_row.office_name_en}',
                f'{model_row.bu_name} / {model_row.bu_name_en}',
                model_row.bu_working_area,
                model_row.bu_working_area_share,
                model_row.bu_public_area,
                model_row.bu_total_area,
            )
            yield self.default_view_row_from_row_data(row_data)

    def column_captions_row(self) -> xlsx.ViewRow:
        return xlsx.ViewRow(
            xlsx.ViewCell(heading_text, {'bg_color': '#D3D3D3'})
            for heading_text in self._headings
        )
