from datetime import date
from typing import List

from django.db.models import QuerySet, Sum, F

from staff.workspace_management.models import Share


def shares_qs(office_ids: List[int]) -> QuerySet:
    today = date.today()
    qs = (
        Share.objects
        .filter(room_share_pie__from_date__lte=today, room_share_pie__to_date__gt=today)
        .filter(room_share_pie__room__floor__office_id__in=office_ids)
        .values('room_share_pie__room__floor__office_id', 'business_unit_id')
        .annotate(used_area=Sum(F('room_share_pie__room_area') * (F('share_value') / 100)))
    )
    return qs
