from datetime import date
from typing import List, Optional

from staff.workspace_management import entities


class GetSharePies:
    def __init__(self, repository: entities.Repository, today: Optional[date] = None) -> None:
        self._today = today or date.today()
        self._repository = repository

    def for_room(self, room_id: int) -> Optional[entities.RoomSharePie]:
        return self._repository.share_pie_for_room_and_date(room_id, self._today)

    def for_rooms(self, room_ids: List[int]) -> List[entities.RoomSharePie]:
        return self._repository.share_pies_for_rooms_and_date(room_ids, self._today)
