from typing import Dict, List, Optional

from staff.users.models import User
from staff.workspace_management import container, entities, use_cases


def user_can_manage_workspace_areas(user: User) -> bool:
    return user.has_perm('workspace_management.can_manage_workspace_areas')


def get_actual_share_pies_for_room(room_id: int) -> Optional[entities.RoomSharePie]:
    use_case: use_cases.GetSharePies = container.build_container()[use_cases.GetSharePies]
    return use_case.for_room(room_id)


def get_actual_share_pies_for_rooms(room_ids: List[int]) -> Dict[int, entities.RoomSharePie]:
    use_case: use_cases.GetSharePies = container.build_container()[use_cases.GetSharePies]
    result = {
        share_pie.room_id: share_pie
        for share_pie in use_case.for_rooms(room_ids)
    }
    return result
