import os
import sys

from sentry_sdk.integrations.wsgi import _ScopedResponse

if 'DEPLOY_STAGE_ID' in os.environ and 'YENV_TYPE' not in os.environ:
    os.environ['YENV_TYPE'] = os.environ['DEPLOY_STAGE_ID']
os.environ['DJANGO_SETTINGS_MODULE'] = 'staff.settings'

if os.getenv('MIDDLEWARE_LOG_LEVEL', '') != 'DEBUG':
    from django.core.wsgi import get_wsgi_application
    application = get_wsgi_application()
else:
    from staff.lib.custom_application import StaffWSGIHandler
    application = StaffWSGIHandler()

warmup_response = application({
    'REQUEST_METHOD': 'GET',
    'SERVER_NAME': '127.0.0.1',
    'SERVER_PORT': 80,
    'PATH_INFO': '/_warmup/',
    'wsgi.input': sys.stdin,
}, lambda x, y: None)

if isinstance(warmup_response, _ScopedResponse):
    warmup_response = warmup_response._response

if warmup_response.status_code != 200:
    raise RuntimeError('Warmup failed')
