# coding: utf-8
import sys
import re


def rows_reader():
    while True:
        row = sys.stdin.readline()
        if not row:
            raise StopIteration
        yield row


def rows_cleaner(rows):
    msgid_re = re.compile(r'^(msgid )?"(.*)"$')

    rows_iter = iter(rows)

    for row in rows_iter:
        if row.strip():
            yield row
        else:
            break

    result = {}
    stack = []
    msgid = ''
    msgid_row = False
    for row in rows_iter:
        if not row.strip() or row.startswith('#'):
            continue

        if msgid_row and row.startswith('"'):
            msgid += msgid_re.match(row).groups()[1]
        else:
            msgid_row = False

        if row.startswith('msgid '):
            if stack:
                result[msgid] = stack
                stack = []
            msgid = msgid_re.match(row).groups()[1]
            msgid_row = True

        stack.append(row)

    if stack:
        result[msgid] = stack

    msgids = result.keys()
    msgids.sort()

    for msgid in msgids:
        yield '\n'
        for row in result[msgid]:
            yield row


def main():
    for row in rows_cleaner(rows_reader()):
        sys.stdout.write(row)


if __name__ == "__main__":
    main()
