apt update
apt install -y docker.io

cat > /etc/docker/daemon.json <<-EOF
{
    "iptables": false,
    "ip-forward": false,
    "ipv6": true,
    "dns": [
        "2a02:6b8:0:3400::1023",
        "2a02:6b8:0:3400::5005"
    ],
    "fixed-cidr": "",
    "fixed-cidr-v6": "fd00::/8"
}
EOF

service docker stop && ip link del docker0 && service docker start
ip6tables -t nat -A POSTROUTING -o eth0 -j MASQUERADE
sysctl -w net.ipv6.conf.all.forwarding=1

echo iptables-persistent iptables-persistent/autosave_v4 boolean false | sudo debconf-set-selections
echo iptables-persistent iptables-persistent/autosave_v6 boolean true | sudo debconf-set-selections
apt install -y iptables-persistent
ip6tables -t nat -A POSTROUTING \! -o docker0 -j MASQUERADE

docker login -u <login> -p <token> registry.yandex.net
