# coding: utf-8
from __future__  import unicode_literals
from fabric.api import env, task, local

from robe import venv

enter = venv.enter
env.robe.projects = {
    'sync_tools': {'path': './',},
}


@task()
def enter(cmd, yenv_type='development.local'):
    with venv.activate():
        local('YENV_TYPE=%s %s' % (yenv_type, cmd))


@task
def test(args='', **kwargs):
    if kwargs:
        args += ' '.join('%s=%s' % (k, v) for k, v in kwargs.items())
    enter('py.test --nomigrations %s --ds=tests.settings' % args, 'development.unittest')
