# flake8: noqa

"""
Workflow для idm, в работе сервиса файл не используется.
Если нужно изменить workflow, то необходимо обновить этот файл и
workflow в системах на idm
"""

roles_for_tvm_apps = []
if user.is_tvm_app and role['role'] not in roles_for_tvm_apps:
    raise AccessDenied('Эта роль недоступна tvm-приложениям')
if not user.is_tvm_app and role['role'] in roles_for_tvm_apps:
    raise AccessDenied('Эта роль доступна только для tvm-приложений')

if role['role'] == 'superuser':
    table_flow_product_manager = groupify('svc_table_flow').get_chain_of_heads(
        up_to_level=0,
        priority_policy=PRIORITY_POLICIES.NO_DEPUTIES
    )
    approvers = [any_from(table_flow_product_manager)]
elif role['role'] == 'rule_editor':
    if parent and parent.system.slug == system.slug:
        approvers = []
    else:
        table_flow_developers = groupify('svc_table_flow_development').members
        approvers = [any_from(table_flow_developers)]
elif role['role'] == 'rule_administrator':
    ref_roles = [{
        'system': system.slug,
        'role_data': {
            'role': 'rule_editor',
            'role_type': 'admin_roles'
        }
    }]
    approvers = [any_from(system.all_users_with_role(role))]
