import time

from django.db import models
from django.contrib.postgres import fields as postgres_fields


def upload_to(instance, fname):
    return f'Rules/{instance.slug}_{time.time()}'


class Rule(models.Model):
    slug = models.SlugField(max_length=30, unique=True)
    file = models.FileField(max_length=512, upload_to=upload_to)
    json = postgres_fields.JSONField(blank=True)
    validation_url = models.URLField(blank=True, default='', help_text='URL для валидации правил')
    tvm_id = models.CharField(blank=True, default='', max_length=32)

    def __str__(self):
        return self.slug


class RuleUser(models.Model):
    rule = models.ForeignKey(Rule, on_delete=models.CASCADE)
    user = models.ForeignKey('users.User', on_delete=models.CASCADE)
