from django.conf import settings

from tvm2 import TVM2
from tvmauth import BlackboxTvmId as BlackboxClientId


def get_tvm_client() -> TVM2:
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        blackbox_client=BlackboxClientId.ProdYateam,
        allowed_clients=settings.YAUTH_TVM2_ALLOWED_CLIENT_IDS,
    )


def get_service_ticket(service: str) -> str or None:
    service_tvm_id = settings.TVM_SERVICES.get(service)
    if service_tvm_id:
        return get_tvm_client().get_service_ticket(str(service_tvm_id))


def get_service_ticket_header(tvm_id):
    return {'X-Ya-Service-Ticket': get_service_ticket(tvm_id)}
