# Generated by Django 2.2.24 on 2021-07-21 15:39

from django.core.management.sql import emit_post_migrate_signal
from django.db import migrations


def apply_migration(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')
    Permission = apps.get_model('auth', 'Permission')
    # используется, чтобы появилсь дефолтные Permission для Rule,
    # подробнее здесь: https://code.djangoproject.com/ticket/23422
    emit_post_migrate_signal(2, False, 'default')
    rule_editors_group = Group.objects.create(name='rule_editors')
    rule_editors_group.permissions.add(
        Permission.objects.get(codename='add_rule'),
        Permission.objects.get(codename='change_rule'),
        Permission.objects.get(codename='view_rule'),
    )


def revert_migration(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')
    Group.objects.get(name='rule_editors').delete()


class Migration(migrations.Migration):
    dependencies = [
        ('users', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(apply_migration, revert_migration)
    ]
