from django.db import models
from django.contrib.auth.models import AbstractUser
from django.utils.translation import ugettext_lazy as _


class User(AbstractUser):
    first_name = models.CharField(_('first name'), max_length=60, blank=True)
    first_name_ru = models.CharField(_('first name(ru)'), max_length=60, blank=True)
    last_name = models.CharField(_('last name'), max_length=60, blank=True)
    last_name_ru = models.CharField(_('last name(ru)'), max_length=60, blank=True)
    staff_id = models.IntegerField(unique=True)
