import os
import django

from django.core.handlers.wsgi import WSGIHandler


def get_application():
    if 'YENV_TYPE' not in os.environ:
        os.environ['YENV_TYPE'] = 'development'
    os.environ['YENV_NAME'] = 'intranet'
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "intranet.table_flow.src.settings")
    django.setup()
    from django.conf import settings  # noqa: F401
    return WSGIHandler()


application = get_application()
