PY3_LIBRARY(table_flow)

OWNER(g:tools-table_flow)

ENV(DJANGO_SETTINGS_MODULE=intranet.table_flow.src.settings)

PEERDIR(
    contrib/python/attrs
    contrib/python/django/django-2.2
    contrib/python/django-model-utils
    contrib/python/django-replicated
    contrib/python/django-storages
    contrib/python/ipython
    contrib/python/more-itertools
    contrib/python/openpyxl
    contrib/python/psycopg2
    contrib/python/pytz
    contrib/python/uwsgi
    contrib/python/requests

    library/python/blackbox
    library/python/granular_settings
    library/python/ids
    library/python/django-idm-api
    library/python/django_tools_log_context
    library/python/django
    library/python/django_pgaas
    library/python/django_template_common
    library/python/python-django-yauth
    library/python/ylog
    library/python/yenv

    intranet/table_flow/src/rules/migrations
    intranet/table_flow/src/users/migrations
)

PY_SRCS(
    __init__.py
    idm/__init__.py
    idm/hooks.py
    idm/workflow.py
    rules/__init__.py
    rules/admin.py
    rules/domain_objs.py
    rules/logic.py
    rules/models.py
    rules/tvm.py
    rules/urls.py
    rules/views.py
    users/__init__.py
    users/admin.py
    users/models.py
    users/staff_sync.py
    manage.py
    settings.py
    urls.py
)
RESOURCE_FILES(
    PREFIX intranet/table_flow/src/

    settings/100-django.conf
    settings/100-django.conf.development
    settings/100-django.conf.testing
    settings/200-logging.conf
    settings/200-logging.conf.development
    settings/300-yauth.conf
    settings/300-yauth.conf.development
    settings/310-tvm.conf.production
    settings/310-tvm.conf
    settings/320-idm.conf
    settings/400-database.conf
    settings/400-database.conf.development
    settings/400-database.conf.development.migration
    settings/500-app.conf
    settings/600-s3.conf
)

END()
