# coding: utf-8

from django.contrib import admin
from tasha import models


class ReadOnlyModelAdmin(admin.ModelAdmin):
    def has_add_permission(self, request):
        return False

    def has_delete_permission(self, request, obj=None):
        return False

    def get_actions(self, request):
        actions = super(ReadOnlyModelAdmin, self).get_actions(request)
        if 'delete_selected' in actions:
            del actions['delete_selected']
        return actions


class UserAdmin(admin.ModelAdmin):
    search_fields = ['uid']


class TgGroupInfoAdmin(admin.ModelAdmin):
    search_fields = ['title']
    list_display = ['title', 'slack_migration_bot_added']
    list_editable = ['should_add_slack_migration_bot']


class TgWhitelistAdmin(admin.ModelAdmin):
    search_fields = ['account']
    list_display = ['account', 'group']
    list_editable = ['account']
    raw_id_fields = (
        'account',
        'group',
        'added_by',
    )


admin_site = admin.AdminSite()
admin_site.register(models.TgGroupInfo, TgGroupInfoAdmin)
admin_site.register(models.TgWhitelistEntry, TgWhitelistAdmin)
