import sys

import click

from tasha.core.tasha_worker.redis_settings import create_redis_pool
from tasha.lib.coro_wrapper import coro_run


@click.command('kick_user')
@click.argument('username', type=str, required=True)
@coro_run
async def kick_user(*, username: str) -> None:
    """
    Job queues in python with asyncio and redis.

    CLI to run the arq worker.
    """
    redis = await create_redis_pool()
    await redis.enqueue_job('kick_leaved_user', username)
