import os
from typing import Iterable

from pydantic import BaseSettings


class Settings(BaseSettings):
    ENV_TYPE: str = 'default'
    DRY_RUN: bool = os.environ.get('DRY_RUN', False)

    REDIS_HOSTS: Iterable[str] = os.environ.get('REDIS_HOST', '').split(',')
    REDIS_PORT: int = os.environ.get('REDIS_PORT', 26379)
    REDIS_PASSWORD: str = os.environ.get('REDIS_PASSWORD', '')
    REDIS_CLUSTER_NAME: str = 'hr-tech-test-redis'
    REDIS_CACHE_EXPIRE_AFTER: int = 3600
    REDIS_LOCK_WAIT_TIMEOUT: int = 30  # seconds
    REDIS_LOCK_TIMEOUT: int = 300  # seconds

    # ARQ
    ARQ_MAX_JOB_TRIES: int = 8
    ARQ_MAX_JOB_COUNT: int = int(os.getenv('ARQ_MAX_JOB_COUNT', 1))
    ARQ_JOBS_COUNT_THRESHOLD = 110  # Сколько задач должно быть в очереди чтоб не пложить новые
    ARQ_FAST_QUEUE_NAME: str = "arq:tasha_queue_fast"
    ARQ_SLOW_QUEUE_NAME: str = "arq:tasha_queue_slow"

    # Telegram
    TELEGRAM_TOKEN: str = os.environ.get('TELEGRAM_TOKEN', '')
    TELEGRAM_TRUE_BOT_USERNAME: str = os.environ.get('TELEGRAM_TRUE_BOT_USERNAME')
    WEBHOOK_URL: str = os.environ.get('WEBHOOK_URL', '')
    TELEGRAM_BOT_USERNAME: str = 'tashatestnaturalbot'
    TELEGRAM_BOT_ACCOUNT_ID: int = 190489

    # Mail
    MAIL_FROM: str = 'robot-uhura@yandex-team.ru'
    REPLY_TO = ['uhura@yandex-team.ru']
    BCC_EMAIL: str = 'tasha-bcc@yandex-team.ru'
    MAIL_TEMPLATES_PATH: str = '/app/tasha/mail_templates/'
    MAIL_ALERT_OFF: bool = os.environ.get('MAIL_ALERT_OFF', False)

    # Staff
    ROBOT_TOKEN = os.environ.get('ROBOT_TOKEN', '')
    STAFF_REQUEST_TIMEOUT = 30
    STAFF_CACHE_TIMEOUT = 10
    STAFF_PAGE_LIMIT = 1000
    EX_YANDEX_MONEY_URL = 'ex_yandex_money'
    TG_WHITELIST = [
        'a_v_a_v_a',
        'snigi',
        'victoriapavlova11',
        'vn23m',
    ]

    # Error booster
    ENABLE_ERROR_BOOSTER: bool = False
    ERROR_BOOSTER_PROJECT_ID: str = 'tasha-testing'
    LOGBROKER_ERROR_BOOSTER_TOPIC: str = '/tasha/test-error-booster'
    ERROR_BOOSTER_SENTRY_DSN: str = os.environ.get('ERROR_BOOSTER_SENTRY_DSN', '')

    # Caches
    TELEGRAM_TO_PG_CACHE_TIMEOUT: int = 10
    KNOWN_CHATS_BOT_CACHE_TIMEOUT: int = 300  # 5min

    # YT
    YT_PROXY: str = 'locke'
    YT_TOKEN: str = os.environ.get('YT_OAUTH_TOKEN')
    YT_TABLE_PATH_EXPORT: str = '//home/tasha/export_test/{}'

