from .default import Settings as DefaultSettings


class Settings(DefaultSettings):
    ENV_TYPE: str = 'production'
    DEBUG: bool = False

    REDIS_CLUSTER_NAME: str = 'hr-tech-prod-redis'

    TELEGRAM_BOT_USERNAME: str = 'tashanaturalbot'
    TELEGRAM_BOT_ACCOUNT_ID: int = 88960

    STAFF_CACHE_TIMEOUT = 3600 * 3  # 3 hours

    # Error booster
    ENABLE_ERROR_BOOSTER: bool = True
    ERROR_BOOSTER_PROJECT_ID: str = 'tasha'
    LOGBROKER_ERROR_BOOSTER_TOPIC: str = '/tasha/error-booster'

    # Caches
    TELEGRAM_TO_PG_CACHE_TIMEOUT: int = 3600 * 3  # 3 hours

    # Staff
    STAFF_REQUEST_TIMEOUT = 10

    # YT
    YT_TABLE_PATH_EXPORT: str = '//home/tasha/export/{}'
