
class ACTION(object):

    EMAIL = 'email'

    # User join/ban actions

    # Мы ботом увидели сообщение "юзер присоединился к группе"
    USER_JOINED_TO_CHAT = 'user_joined'
    # Мы ботом увидели сообщение "юзер позвали в группу"
    USER_INVITED_TO_CHAT = 'user_invited'
    # Забанили юзера нестоящим ботом
    USER_BANNED_BY_BOT = 'user_banned_bot'
    # Разбанили юзера настоящим ботом
    USER_UNBANNED_BY_BOT = 'user_unbanned_by_bot'
    # Разбанили юзера ненастоящим ботом
    USER_UNBANNED_BY_SUBBOT = 'user_unbanned_by_subbot'
    # Забанили бота старой Ташей(старая Таша пишет этот экшн в базу)
    USER_BANNED_BY_SUBBOT = 'user_banned_subbot'
    # Юзера забанил кто-то кроме ботов безопасности(мы увидели сообщение об этом)
    USER_BANNED_BY_USER = 'user_banned_user'
    # Мы не смогли забанить юзера
    USER_BAN_FAILED = 'user_ban_failed'
    # Мы увидели сообщение "юзер покинул группу"
    USER_LEAVED = 'user_leaved'
    # При попытке кикнуть получили ответ, что человека нет в чате
    USER_NOT_PARTICIPANT = 'user_not_participant'

    # Если мы не смогли забанить юзера, мы его удаляем
    # Юзера удалил настоящий бот
    USER_DELETED_BY_BOT = 'user_deleted_bot'
    # Юзера удалила старая Таша
    USER_DELETED_BY_SUB = 'user_deleted_sub'
    # Юзера удалил кто-то кроме ботов безопасности(мы увидели сообщение об этом)
    USER_DELETED_BY_USER = 'user_deleted_user'
    # Мы не смогли удалить юзера
    USER_DELETE_FAILED = 'user_delete_failed'

    # Membership detection actions

    # Мы узнали о членстве из регулярного обхода группы старой ташей
    USER_DETECTED_BY_SUBBOT = 'detected_sub'
    # Мы узнали о членстве поймав настоящим ботом сообщение телеги о новом члене группы
    USER_DETECTED_BY_INVITE_MESSAGE = 'detected_invite'
    # Мы узнали о членстве когда юзер что-то написал
    USER_DETECTED_BY_REGULAR_MESSAGE = 'detected_message'

    # Пользователь в группе получил права админа
    USER_GRANTED_ADMIN_RIGHTS = 'user_granted_admin_rights'
    # Пользователь в группе лишился прав админа
    USER_LOST_ADMIN_RIGHTS = 'user_lost_admin_rights'

    # Валидный пользователь сменил username в телеграме
    USER_CHANGED_USERNAME = 'user_changed_username'
    # Валидный пользователь отвязал телеграм на стаффе
    USER_DELETED_TELEGRAM = 'user_deleted_telegram'

    # Group actions

    # Бота пригласили в группу, которую юзер сделал сам
    BOT_INVITED_IN_EXT_GROUP = 'bot_invited_ext'
    # Чат создан ухурой, боты добавлены нашим кодом
    UHURA_CREATED_GROUP = 'uhura_created_group'
    # Бота забанили азазазаза
    BOT_BANNED_IN_GROUP = 'bot_banned'

    # Бот завёл группу пост-фактум, получив сообщение из неё.
    BOT_DETECTED_NEW_CHAT = 'bot_detected_new_chat'

    choices = [
        (USER_JOINED_TO_CHAT, 'User joined'),
        (USER_INVITED_TO_CHAT, 'User invited'),
        (USER_BANNED_BY_BOT, 'User banned by bot'),
        (USER_BANNED_BY_SUBBOT, 'User banned by subbot'),
        (USER_BANNED_BY_USER, 'User banned by user'),
        (USER_BAN_FAILED, 'User ban failed'),
        (USER_LEAVED, 'User leaved'),
        (USER_DETECTED_BY_SUBBOT, 'Detected sub'),
        (USER_DETECTED_BY_INVITE_MESSAGE, 'Detected invite'),
        (USER_DETECTED_BY_REGULAR_MESSAGE, 'Detected message'),
        (BOT_INVITED_IN_EXT_GROUP, 'Bot invited'),
        (UHURA_CREATED_GROUP, 'Uhura created group'),
        (BOT_BANNED_IN_GROUP, 'Bot banned'),
        (USER_DELETED_BY_BOT, 'User deleted by bot'),
        (USER_DELETED_BY_SUB, 'User deleted by subbot'),
        (USER_DELETED_BY_USER, 'User deleted by user'),
        (USER_DELETE_FAILED, 'User delete failed'),
        (USER_GRANTED_ADMIN_RIGHTS, 'User granted admin rights'),
        (USER_LOST_ADMIN_RIGHTS, 'User lost admin rights'),
        (USER_UNBANNED_BY_BOT, 'User unbanned by bot'),
        (USER_UNBANNED_BY_SUBBOT, 'User unbanned by subbot'),
        (BOT_DETECTED_NEW_CHAT, 'Bot detected new chat')
    ]

    user_bans = {USER_BANNED_BY_BOT, USER_BANNED_BY_SUBBOT, USER_BANNED_BY_USER}
    user_deletes = {USER_DELETED_BY_BOT, USER_DELETED_BY_SUB, USER_DELETED_BY_USER, USER_LEAVED, USER_NOT_PARTICIPANT}
    user_fails = {USER_BAN_FAILED, USER_DELETE_FAILED}
    user_joins = {USER_JOINED_TO_CHAT, USER_INVITED_TO_CHAT}
    user_enter_to_chat = user_joins | {USER_DETECTED_BY_SUBBOT, USER_DETECTED_BY_INVITE_MESSAGE,
                                       USER_DETECTED_BY_REGULAR_MESSAGE}
    user_kicked = user_bans | {USER_DELETED_BY_BOT, USER_DELETED_BY_SUB}
    user_invalidations = {USER_DELETED_TELEGRAM, USER_CHANGED_USERNAME}


class CHAT_TYPE:
    PRIVATE = 'private'
    GROUP = 'group'
    SUPERGROUP = 'supergroup'
    CHANNEL = 'channel'

    choices = [
        (PRIVATE, 'Private'),
        (GROUP, 'Group'),
        (SUPERGROUP, 'Supergroup'),
        (CHANNEL, 'Channel'),
    ]
