from tasha.core.services.base import BaseService


class TashaService(BaseService):
    async def get_users_to_unban(self):
        return await self._tu.action.get_banned_users()

    async def get_queue_length(self, queue_name: str):
        return await self._tu.redis.queued_jobs(queue_name=queue_name)

    async def get_least_scanned_chats(self, limit: int = None):
        return await self._tu.chat.get_least_scanned_chats(limit)
