import random
import logging

from aiogram import types
from django.conf import settings

from tasha.constants import ACTION
from tasha.lib import mail
from tasha.utils import is_in_whitelist

logger = logging.getLogger(__name__)


def get_shard_number() -> int or None:
    if not settings.SHARD_NUMBERS:
        return None
    return random.choice(settings.SHARD_NUMBERS)


def get_enter_action(inviter_id: int, user_id: int):
    if inviter_id == user_id:
        return ACTION.USER_JOINED_TO_CHAT
    else:
        return ACTION.USER_INVITED_TO_CHAT


def get_exit_action(banner_id, user_id, bot_id):
    if banner_id == user_id:
        return ACTION.USER_LEAVED
    elif banner_id == bot_id:
        return ACTION.USER_BANNED_BY_BOT
    else:
        return ACTION.USER_BANNED_BY_USER


def is_valid_user(chat_id, invited_user: types.User, is_active_user: bool, whitelist):
    if is_active_user:
        return True
    if invited_user.is_bot:
        return True
    if is_in_whitelist(invited_user.username, invited_user.id, whitelist):
        logger.info('[%s] User in whitelist. Username: %s', chat_id, invited_user.username)
        return True
    return False


async def notify_admin(db_proxy, chat: types.Chat, problem_user: types.User):
    chat_name = chat.title
    admins_emails = await db_proxy.get_admin_emails(chat.id)

    users = [{
        'id': problem_user.id,
        'first_name': problem_user.first_name,
        'last_name': problem_user.last_name,
        'username': problem_user.username
    }]
    await mail.notify_about_not_kicked_users(
        bot_username=settings.TELEGRAM_BOT_USERNAME,
        admins_emails=admins_emails,
        not_kicked_users=users,
        chat_title=chat_name,
        chat_id=chat.id,
        db_proxy=db_proxy,
    )
