import hashlib
import logging

from aiogram import Bot, Dispatcher
from aiogram.utils import executor
from aiogram.utils.executor import start_webhook
from django.conf import settings
from ids.utils import https as ids_https

from tasha.core.tasha_bot.tasha_handlers import TashaHandlers

POLLING_MODE = settings.WEBHOOK_URL is None

logger = logging.getLogger(__name__)

bot = Bot(token=settings.TELEGRAM_TOKEN)
dispatcher = Dispatcher(bot=bot)

bot_handlers = TashaHandlers(bot=bot)

hasher = hashlib.sha1()
hasher.update(settings.TELEGRAM_TOKEN.encode())
wtoken = hasher.hexdigest()

WEBHOOK_HOST = settings.WEBHOOK_URL


class TashaBot(object):
    _webhook_path: str = ''
    _webhook_callback = ''

    def __init__(self, path=None, on_startup=None, on_shutdown=None):
        self.on_startup = on_startup
        self.on_shutdown = on_shutdown

        self._webhook_path = f'/webhook/{f"{path}/" if path else ""}{wtoken}'
        self._webhook_callback = f"{WEBHOOK_HOST}{self._webhook_path}"

    def start(self):
        if POLLING_MODE:
            return executor.start_polling(dispatcher)
        else:
            return start_webhook(
                dispatcher=dispatcher,
                webhook_path=self._webhook_path,
                on_startup=self._on_bot_startup,
                on_shutdown=self._on_bot_shutdown,
                host='::',
                port=80,
                access_log=None
            )

    async def _on_bot_startup(self, dp: Dispatcher):
        await bot_handlers.async_init()

        if self.on_startup is not None:
            await self.on_startup(dp, bot_handlers)

        cert_path = ids_https.get_ca_bundle_path()
        await bot.set_webhook(
            url=self._webhook_callback,
            certificate=open(cert_path),
            allowed_updates=[],
        )

        logger.info('Webhook listen started')

    async def _on_bot_shutdown(self, dp: Dispatcher):
        if self.on_shutdown is not None:
            await self.on_shutdown(dp)

        logger.warning('Shutting down..')
        await bot.delete_webhook()
        await dp.storage.close()
        await dp.storage.wait_closed()
