from arq import create_pool
from arq.connections import RedisSettings, ArqRedis

from tasha.config import settings

sentinel_host = [(h, settings.REDIS_PORT) for h in settings.REDIS_HOSTS]


def get_redis_settings():
    return RedisSettings(
        host=sentinel_host,
        sentinel=True,
        sentinel_master=settings.REDIS_CLUSTER_NAME,
        password=settings.REDIS_PASSWORD,
    )


async def create_redis_pool() -> ArqRedis:
    return await create_pool(
        settings_=get_redis_settings(),
        default_queue_name=settings.ARQ_FAST_QUEUE_NAME,
    )
