import logging
from typing import Iterable

from tasha.config import settings
from tasha.constants import ACTION
from tasha.db.gateways.base import DBGateway

logger = logging.getLogger(__name__)


class ActionGateway(DBGateway):
    async def add_action_to_membership(
            self, action, membership_id=None, account_id=None, group_id=None,
            telegram_id=None, chat_telegram_id=None
    ):
        if membership_id is not None:
            await self.conn.execute('''
               INSERT INTO tasha_actions (added, action, membership_id)
               VALUES (CURRENT_TIMESTAMP, $1, $2::numeric)
           ''', action, membership_id)
        elif account_id is not None and group_id is not None:
            await self.conn.execute('''
               INSERT INTO tasha_actions (added, action, membership_id)
               VALUES (CURRENT_TIMESTAMP, $1,
                   (SELECT id FROM tasha_membership WHERE account_id = $2::numeric AND group_id = $3::numeric))
           ''', action, account_id, group_id)
        elif telegram_id is not None and chat_telegram_id is not None:
            await self.conn.execute('''
               INSERT INTO tasha_actions (added, action, membership_id)
               VALUES (
                   CURRENT_TIMESTAMP, $1, (
                       SELECT tasha_membership.id
                       FROM tasha_membership
                       JOIN tasha_tggroupinfo ON tasha_membership.group_id = tasha_tggroupinfo.id
                       JOIN tasha_telegramaccount ON tasha_membership.account_id = tasha_telegramaccount.id
                       WHERE tasha_telegramaccount.telegram_id = $2 AND tasha_tggroupinfo.telegram_id = $3
                   )
               )
           ''', action, telegram_id, chat_telegram_id)
        else:
            raise AssertionError('Wrong params')

    async def get_banned_users(self) -> Iterable[str]:
        select_sql = '''
            SELECT DISTINCT tu.username as username
            FROM (
                    SELECT act.membership_id, MAX(act.added) as added
                    FROM tasha_actions act
                    GROUP BY act.membership_id
                 ) as latest_actions
            INNER JOIN tasha_actions actions USING (membership_id, added)
            INNER JOIN tasha_membership tm on tm.id = actions.membership_id
            INNER JOIN tasha_tggroupinfo tg on tg.id = tm.group_id
            INNER JOIN tasha_telegramaccount ta on ta.id = tm.account_id
            INNER JOIN tasha_user tu on tu.id = ta.user_id
            WHERE
                actions.action = ANY($1::varchar[])
                AND NOT tg.deactivated
                AND tu.is_active
        '''
        rows = await self.conn.fetch(select_sql, ACTION.user_kicked - {ACTION.USER_BANNED_BY_USER})
        return [row['username'] for row in rows]
