import logging
from datetime import datetime

from tasha.core.models import SyncTime
from tasha.db.gateways.base import DBGateway

logger = logging.getLogger(__name__)


class SyncTimeGateway(DBGateway):
    async def get(self, name: str) -> SyncTime or None:
        select_query = '''
            SELECT *
            FROM tasha_synctime as sync
            WHERE sync.name = $1
                        '''
        row = await self.conn.fetchrow(select_query, name)
        return SyncTime(**row) if row else None

    async def create(self, name: str):
        create_sync_time_sql = '''
            INSERT INTO tasha_synctime (name, last_success_start)
            VALUES (
                $1,
                $3
            )
            ON CONFLICT (name)
            DO UPDATE SET
                last_success_start = $3
            RETURNING last_success_start;
                '''
        await self.conn.fetch(create_sync_time_sql, name, datetime.now())

    async def update(self, name: str, last_success_start: datetime):
        update_time_query = '''
            UPDATE tasha_synctime
            SET last_success_start = $2
            WHERE name = $1
        '''
        await self.conn.execute(update_time_query, name, last_success_start)
