import logging
from typing import Iterable

from tasha.db.gateways.account import TgAccount
from tasha.db.gateways.base import DBGateway

logger = logging.getLogger(__name__)


class WhitelistGateway(DBGateway):
    async def get_chat_whitelist_users(self, chat_id: int) -> list[TgAccount]:
        select_query = '''
            SELECT acc.telegram_id as telegram_id, acc.username as username, acc.is_bot as is_bot
            FROM tasha_whitelist_entry whl
              INNER JOIN tasha_tggroupinfo gr on whl.group_id = gr.id
              INNER JOIN tasha_telegramaccount acc on whl.user_account_id = acc.id
            WHERE gr.telegram_id = $1 AND whl.is_active = TRUE
        '''
        rows = await self.conn.fetch(select_query, chat_id)
        return [TgAccount(**row) for row in rows]
