import logging

import sentry_sdk
from sentry_sdk import set_tag
from sentry_sdk.integrations.logging import LoggingIntegration

from tasha.config import settings

logger = logging.getLogger(__name__)


def init_error_booster():
    if not settings.ENABLE_ERROR_BOOSTER:
        logger.warning('Error booster disabled')
        return

    sentry_logging = LoggingIntegration(
        level=logging.INFO,  # Capture info and above as breadcrumbs
        event_level=logging.ERROR  # Send errors as events
    )

    sentry_sdk.init(
        settings.ERROR_BOOSTER_SENTRY_DSN,
        # Set traces_sample_rate to 1.0 to capture 100%
        # of transactions for performance monitoring.
        # We recommend adjusting this value in production.
        traces_sample_rate=1.0,
        release="release_version",
        environment="production",
        integrations=[sentry_logging]
    )

    set_tag("project", "tasha")
    set_tag("service", "tasha")
    logger.info('Error Booster inited')

# set_user({"yandexuid": "12345678890", "ip_address": "192.168.1.1", "puid": "12931231231"})
#
# set_tag("platform", "desktop")
#
# set_tag("page", "custom_page")
# set_tag("url", "https://yandex.com/python")
# set_tag("slots", "123123,12,12;5555,3,1")
# set_tag("dc", "vla")
# set_tag("reqid", "request-id-1234")
# set_tag("experiments", "aaa=1;bb=7;ccc=yes;ddd")
# set_tag("isInternal", "true")
# set_tag("isRobot", "true")
# set_tag("loggedin", "true")
# set_tag("isAdblock", "true")
# set_tag("region", "199")
# set_tag("useragent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3826.0 Safari/537.36")
# set_tag("source", "source")
# set_tag("sourceMethod", "sourceMethod")
# set_tag("sourceType", "sourceType")
# set_tag("block", "block")
# set_tag("method", "method")
# set_tag("my_tag", "my_tag_value")

# add_breadcrumb(
#     type='navigation',
#     category='auth',
#     message='Authenticated user test@yandex-team.ru',
#     level='info',
#     data={
#         "from": "/login",
#         "to": "/dashboard"
#     }
# )
#
# sentry_sdk.set_context("character", {
#     "name": "Mighty Fighter",
#     "age": 19,
#     "attack_type": "melee"
# })
#
# capture_message("Hello World")
#
# logging.error('Protocol problem: %s', 'connection reset', extra=dict(extra_key="extra_value"))
# logging.error('Protocol problem: %s, %s', 'connection reset', 'connection bad', extra=dict(extra_key="extra_value"))
#
# raise ValueError("It really works!")
