# coding: utf-8

from __future__ import unicode_literals

from ids.registry import registry
import ids

from tasha.config import settings
from tasha.lib import cache_storage


persons = registry.get_repository(
    'staff', 'person',
    user_agent='uhura', oauth_token=settings.ROBOT_TOKEN, retries=5, timeout=settings.STAFF_REQUEST_TIMEOUT
)


@cache_storage.memoize_decorator(fresh_time=settings.STAFF_CACHE_TIMEOUT)
def get_person_data_by_userphone(phone):
    if not phone:
        return None
    if not phone.startswith('+'):
        phone = '+%s' % phone
    try:
        return persons.get_one(lookup={
            '_query': 'phones.number == "%s" and official.is_dismissed == False' % phone
        })
    except ids.exceptions.BackendError as e:
        if e.status_code == 404:
            return None
        else:
            raise


@cache_storage.memoize_decorator(fresh_time=settings.STAFF_CACHE_TIMEOUT)
def get_person_data_by_username(username):
    if not username:
        return None
    try:
        return persons.get_one(lookup={
            'login': username,
            '_query': 'official.is_dismissed == False',
        })
    except ids.exceptions.BackendError as e:
        if e.status_code == 404:
            return None
        else:
            raise


@cache_storage.memoize_decorator(fresh_time=settings.STAFF_CACHE_TIMEOUT)
def is_dismissed_person(login):
    not_dismissed = 'official.is_dismissed == False'
    not_ex_yandex_money = (
        f'department_group.url != "{settings.EX_YANDEX_MONEY_URL}"'
        + f'and department_group.ancestors.url != "{settings.EX_YANDEX_MONEY_URL}"'
    )
    try:
        person_data = persons.get_one(lookup={
            'login': login.lower(),
            '_query': f'{not_dismissed} and {not_ex_yandex_money}',
        })
        return person_data is None
    except ids.exceptions.BackendError as e:
        if e.status_code == 404:
            return True
        else:
            raise


def find_telegram_accounts(accounts):
    return {account['value'] for account in accounts if account['type'] == 'telegram'}
