import os

from pyrogram import Client, types, enums

from tasha.config import settings


class TelegramClient(object):
    def __init__(self):
        api_id = int(os.environ['API_ID'])
        api_hash = os.environ['API_HASH']
        bot_token = settings.TELEGRAM_TOKEN

        self._py_client = Client(
            "tasha-pyrogram",
            api_id=api_id, api_hash=api_hash,
            bot_token=bot_token,
            takeout=True,
            no_updates=True,
            ipv6=True,
        )

    async def start(self):
        await self._py_client.start()

    async def stop(self):
        await self._py_client.stop()

    async def get_chat_members(self, chat_id: int) -> list[types.ChatMember]:
        all_members = []
        async for member in self._py_client.get_chat_members(chat_id):
            all_members.append(member)
        return all_members

    async def get_admins(self, chat_id: int) -> list[types.ChatMember]:
        all_members = []
        async for member in self._py_client.get_chat_members(chat_id, filter=enums.ChatMembersFilter.ADMINISTRATORS):
            all_members.append(member)
        return all_members
