import logging
from telethon import client, hints, functions, types
from django.conf import settings


logger = logging.getLogger(__name__)


class TelegramClient(client.TelegramClient):
    async def get_input_entity(self: 'TelegramClient',
                               peer: 'hints.EntityLike',
                               q: str = None) -> 'types.TypeInputPeer':
        try:
            result = await super().get_input_entity(peer)
        except ValueError:
            if q is None and isinstance(peer, str):
                q = peer

            if q:
                await self(functions.contacts.SearchRequest(q, 1000))
                result = await super().get_input_entity(peer)

            else:
                raise

        return result

    async def get_entity(self: 'TelegramClient',
                         entity: 'hints.EntitiesLike',
                         q: str = None) -> 'hints.Entity':
        try:
            result = await super().get_entity(entity)
        except ValueError:
            if settings.IS_GOD_BOT:
                raise  # Дальше нет смысла, т.к. запросы search не делаются от имени бота.

            if q is None and isinstance(entity, str):
                q = entity

            if q:
                await self(functions.contacts.SearchRequest(q, 1000))
                result = await super().get_entity(entity)

            else:
                raise

        return result
