import os
import sys
from logging.config import dictConfig
from typing import cast, TYPE_CHECKING

import click
from arq import run_worker
from pydantic.utils import import_string

from tasha.error_booster import init_error_booster
from tasha.lib.logging import LOGGING_CONFIG

if TYPE_CHECKING:
    from arq.typing import WorkerSettingsType


@click.command('worker')
@click.argument('worker-settings', type=str, required=True)
def worker(*, worker_settings: str) -> None:
    """
    Job queues in python with asyncio and redis.

    CLI to run the arq worker.
    """
    sys.path.append(os.getcwd())
    worker_settings_ = cast('WorkerSettingsType', import_string(worker_settings))

    dictConfig(LOGGING_CONFIG)
    init_error_booster()

    run_worker(worker_settings_)
