import logging
import os

import yt.wrapper

from tasha.lib.export.base import BaseExport
from tasha.lib.export.constants import TOP_POPULAR_CHANNELS
from tasha.config import settings

yt.wrapper.config["token"] = settings.YT_TOKEN
yt.wrapper.config["proxy"]["url"] = settings.YT_PROXY
logger = logging.getLogger(__name__)
channels = TOP_POPULAR_CHANNELS


def count_intersection(first_members, second_members):
    """
    The func is counting intersections of users between two given channels
    """
    left_set = set(first_members)
    right_set = set(second_members)
    cnt_intersection = round(len(left_set.intersection(right_set)) / len(first_members) * 100) # % of intersection
    return cnt_intersection


class ChatStatExport(BaseExport):
    """
    Counting intersections of users between a channel and all other channels from rows including self
    """
    async def export_chat_stats(self, db_proxy):
        rows = await db_proxy.get_top_channels(channels)
        data = []
        for row in rows:
            d = {'Aa Title': row['title']}  # "Aa" prefix to force this column to stand first in YT
            for i in range(len(rows)):
                d[rows[i]['title']] = count_intersection(row['members'], rows[i]['members'])

            data.append(d)

        yt_table_path = settings.YT_TABLE_PATH_EXPORT
        path = yt_table_path.format('chat_stats')
        client = yt.wrapper.YtClient(settings.YT_PROXY, token=settings.YT_TOKEN)
        table = client.TablePath(path, append=False)
        logger.info('writing data to YT %s', path)
        client.write_table(table, data, force_create=True)
        logger.info('writing data to YT done')
        logger.info('handling ExportChatStats done')

