import logging
import os
import typing

import yt.wrapper
import yt.wrapper.schema as schema
from django.conf import settings

from tasha.lib.export.base import BaseExport

yt.wrapper.config["token"] = settings.YT_TOKEN
yt.wrapper.config["proxy"]["url"] = settings.YT_PROXY

logger = logging.getLogger(__name__)


@yt.wrapper.yt_dataclass
class GroupRow:
    telegram: schema.Int64
    title: str
    members: typing.List[str]
    admins: typing.List[str]
    last_scan: typing.Optional[str] = ''
    type: typing.Optional[str] = ''


class TelegramExport(BaseExport):
    async def export(self, db_proxy):
        logger.info('handle TelegramExport')
        rows = await db_proxy.export_groups()
        logger.info('get export groups from db')

        data = [
            GroupRow(
                telegram=g['telegram'],
                title=g['title'],
                type=g['type'],
                last_scan=f'{g["last_scan"]}',
                admins=[v for v in g['admins']] if g['admins'] else [],
                members=[v for v in g['members']] if g['members'] else []
            ) for g in rows
        ]

        yt_table_path = settings.YT_TABLE_PATH
        path = yt_table_path.format('groups')
        client = yt.wrapper.YtClient('locke', token=os.environ.get('YT_OAUTH_TOKEN'))

        table = client.TablePath(path, append=False)
        logger.info('write data to YT %s', path)
        client.write_table_structured(table, GroupRow, data, force_create=True)
        logger.info('write data to YT done')
        logger.info('handle TelegramExport done')
