import logging

from cached_property import cached_property

from .base import BaseAsyncContext
from .collector import ContextCollector


class ArqLogContext(BaseAsyncContext):
    TAG = 'arq'

    def __init__(self, task, ctx, **kwargs):
        self.task = task
        self.ctx = ctx
        super().__init__(**kwargs)

    def log_after_execution(self, context):
        arq_data = context.get('arq', {})
        logging.info(
            'arq job %s finished after attempt %d (took %.3f ms)',
            arq_data.get('job_name'),
            arq_data.get('job_try'),
            context.get('execution_time'),
        )

    @cached_property
    def collector(self):
        return ContextCollector(arq_task=self.task, arq_context=self.ctx)


arq_log_context = ArqLogContext
