from .providers import BaseProvider


class ContextCollector:
    """
    Класс, собирающий контекст из провайдеров.
    Получает всех наследников BaseProvider, вызывает у каждого из них collect_data.
    """

    def __init__(self, **kwargs):
        self.providers = [cls(**kwargs) for cls in BaseProvider.__subclasses__()]

    def collect(self, tag=None, **kwargs):
        context = kwargs
        for provider in self.providers:
            context.update(provider.collect_data(tag=tag))
        return context
