import sys

from tasha.config import settings

LOG_FORMAT = 'json' if settings.ENV_TYPE != 'development' else 'default'
ENV_LOG_LEVEL = 'DEBUG' if settings.DEBUG else 'INFO'
LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
            'level': ENV_LOG_LEVEL,
        },
    },
    'loggers': {
        'tasha': {
            'handlers': ['stream'],
            'propagate': False,
            'level': ENV_LOG_LEVEL,
        },
        'ids': {'level': 'DEBUG'},
        'urllib3': {
            'level': 'ERROR'
        },
        'aioredis': {'level': 'ERROR'},
        'arq.worker': {
            'level': 'WARNING'
        },
        'pyrogram': {
            'level': 'WARNING'
        }
    },
    'root': {
        'handlers': ['stream'],
        'level': ENV_LOG_LEVEL,
    },
}
