from tasha.core.models import User
from tasha.lib.staff.staff_person import StaffPerson


def has_changes(user: User, person: StaffPerson):
    """
    Смотрит есть ли разница между моделью пользователя из базы и пользователя со стаффа
    """
    meaningful_fields = ['username', 'is_active', 'quit_at', 'email', 'join_at', 'organization_id', 'affiliation']
    return any(getattr(user, field) != getattr(person, field) for field in meaningful_fields)
