def safe_getitem(data, path: list[str], default=None):
    try:
        for key in path:
            data = data[key]
    except (KeyError, IndexError, TypeError):
        return default
    return data


def is_hashable(value):
    if isinstance(value, (list, dict)):
        return True
    try:
        hash(value)
    except TypeError:
        return False
    return True


def freeze(value):
    if not is_hashable(value):
        return None
    if isinstance(value, dict):
        freeze_nested = {
            k: freeze(v)
            for k, v in value.items()
        }
        return frozenset(freeze_nested.items())
    if isinstance(value, (list, tuple, set)):
        return tuple([freeze(item) for item in value])
    return value


def make_hash(value):
    return str(hash(freeze(value)))
