# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-04-12 16:26
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('tasha', '0005_latesttgstatistics'),
    ]

    operations = [
        migrations.CreateModel(
            name='TelethonEntity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_name', models.CharField(db_index=True, max_length=32)),
                ('telegram_id', models.BigIntegerField(db_index=True)),
                ('access_hash', models.BigIntegerField()),
                ('username', models.CharField(max_length=255, null=True)),
                ('phone', models.BigIntegerField(null=True)),
                ('name', models.CharField(max_length=255, null=True)),
            ],
            options={
                'db_table': 'tasha.tasha_telethonentity',
            },
        ),
        migrations.CreateModel(
            name='TelethonSentFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_name', models.CharField(db_index=True, max_length=32)),
                ('md5_digest', models.BinaryField(db_index=True)),
                ('file_size', models.IntegerField()),
                ('file_type', models.IntegerField(db_index=True)),
                ('file_id', models.BigIntegerField()),
                ('access_hash', models.IntegerField()),
            ],
            options={
                'db_table': 'tasha.tasha_telethonsentfile',
            },
        ),
        migrations.CreateModel(
            name='TelethonSession',
            fields=[
                ('session_name', models.CharField(max_length=32, primary_key=True, serialize=False)),
                ('dc_id', models.IntegerField()),
                ('server_address', models.CharField(max_length=255)),
                ('port', models.IntegerField()),
                ('auth_key', models.BinaryField(null=True)),
            ],
            options={
                'db_table': 'tasha.tasha_telethonsession',
            },
        ),
        migrations.CreateModel(
            name='TgGroupInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('telegram_id', models.BigIntegerField(db_index=True)),
                ('deactivated', models.BooleanField(db_index=True, default=False)),
                ('bot_user_id', models.CharField(db_index=True, max_length=255)),
                ('bot_username', models.CharField(max_length=255)),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField()),
            ],
            options={
                'db_table': 'tasha.tasha_tggroupinfo',
            },
        ),
        migrations.DeleteModel(
            name='TgStatistics',
        ),
        migrations.AlterUniqueTogether(
            name='tggroupinfo',
            unique_together=set([('telegram_id', 'bot_user_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='telethonsentfile',
            unique_together=set([('md5_digest', 'file_size', 'file_type')]),
        ),
        migrations.AlterUniqueTogether(
            name='telethonentity',
            unique_together=set([('session_name', 'telegram_id')]),
        ),
    ]
