# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2019-04-10 08:31
from __future__ import unicode_literals

import os

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('tasha', '0008_add_membership_model_and_actions'),
    ]

    operations = [
        migrations.CreateModel(
            name='TelegramUsername',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_with_uhura', models.BooleanField(default=False)),
                ('username', models.CharField(db_index=True, null=True, max_length=255, unique=True)),
                ('telegram_id', models.BigIntegerField(db_index=True, null=True, unique=True)),
                ('is_bot', models.BooleanField(default=False)),
                ('is_tasha', models.BooleanField(default=False))
            ],
            options={
                'db_table': 'uhura_telegramusername',
                'managed': bool(os.environ.get('TASHA_TEST_RUN', False)),
            },
        ),
        migrations.AddField(
            model_name='tgmembership',
            name='username',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='tasha.TelegramUsername'),
        ),
        migrations.AddField(
            model_name='telegramusername',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='tasha.User')
        ),
        migrations.AlterUniqueTogether(
            name='tgmembership',
            unique_together=set([('username', 'group')]),
        ),
    ] + (
        [
            migrations.RunSQL('ALTER TABLE uhura_telegramusername ALTER COLUMN is_tasha SET DEFAULT FALSE'),
            migrations.RunSQL('ALTER TABLE uhura_telegramusername ALTER COLUMN created_with_uhura SET DEFAULT FALSE'),
        ]
        if os.environ.get('TASHA_TEST_RUN', False) else []
    )
