# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2019-05-22 08:51
from __future__ import unicode_literals

from django.contrib.postgres.aggregates import ArrayAgg
from django.db import migrations, models


def create_tashas(apps, schema_editor):
    TgGroupInfo = apps.get_model('tasha', 'TgGroupInfo')
    TelegramUsername = apps.get_model('tasha', 'TelegramUsername')

    tashas_telegram_ids = TgGroupInfo.objects.values_list('bot_user_id', flat=True).distinct()
    TelegramUsername.objects.filter(telegram_id__in=map(int, tashas_telegram_ids)).update(is_tasha=True)


def merge_groups(apps, schema_editor):
    TgGroupInfo = apps.get_model('tasha', 'TgGroupInfo')
    TgMembership = apps.get_model('tasha', 'TgMembership')

    groups = TgGroupInfo.objects.values('telegram_id').annotate(ids=ArrayAgg('id')).values_list('telegram_id', 'ids')
    for telegram_id, groups_ids in groups:
        if len(groups_ids) > 1:
            main_group_id = groups_ids[0]
            other_groups_ids = groups_ids[1:]
            membeships_telegram_ids = TgMembership.objects.filter(group_id=main_group_id).values_list('username__telegram_id', flat=True)
            TgMembership.objects.filter(group_id__in=other_groups_ids).exclude(useranme__telegram_id__in=membeships_telegram_ids).update(group_id=main_group_id)
            TgGroupInfo.objects.filter(id__in=other_groups_ids).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('tasha', '0013_add_is_admin_field_in_tgmembership'),
    ]

    operations = [
        migrations.RunPython(create_tashas, migrations.RunPython.noop),
        migrations.AlterUniqueTogether(
            name='tggroupinfo',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='tggroupinfo',
            name='bot_user_id',
        ),
        migrations.RemoveField(
            model_name='tggroupinfo',
            name='bot_username',
        ),
        migrations.RunPython(merge_groups, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='tggroupinfo',
            name='telegram_id',
            field=models.BigIntegerField(db_index=True, unique=True),
        ),
        migrations.RunSQL('ALTER TABLE "tasha.actions" ADD CONSTRAINT action_check CHECK (membership_id is not null or group_id is not null)')
    ]
