# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2019-05-25 21:33
from __future__ import unicode_literals

from django.db import migrations, models


def metadata_to_title(apps, schema_editor):
    TgGroupInfo = apps.get_model('tasha', 'TgGroupInfo')
    for group in TgGroupInfo.objects.filter(metadata__title__isnull=False):
        group.title = group.metadata['title']
        group.save(update_fields=['title'])


class Migration(migrations.Migration):

    dependencies = [
        ('tasha', '0014_auto_20190522_1151'),
    ]

    operations = [
        migrations.AddField(
            model_name='tggroupinfo',
            name='title',
            field=models.TextField(default=''),
            preserve_default=False,
        ),
        migrations.RunPython(metadata_to_title, migrations.RunPython.noop),
        migrations.RemoveField(
            model_name='tggroupinfo',
            name='metadata',
        ),
    ]
