# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2019-06-08 13:36
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def fill_first_notified_from_email(apps, schema_editor):
    TgMembership = apps.get_model('tasha', 'TgMembership')
    Action = apps.get_model('tasha', 'Action')
    actions = (
        Action
        .objects
        .filter(action='email', membership__isnull=False)
        .order_by('-added')
        .values_list('membership', 'added')
    )
    notified_memberships = {membership: added for membership, added in actions}
    memberships = TgMembership.objects.filter(pk__in=notified_memberships.keys())
    for membership in memberships:
        membership.first_notified_from_email = notified_memberships[membership.pk]
        membership.save(update_fields=['first_notified_from_email'])


class Migration(migrations.Migration):

    dependencies = [
        ('tasha', '0015_auto_20190526_0033'),
    ]

    operations = [
        migrations.AddField(
            model_name='tgmembership',
            name='first_notified_from_email',
            field=models.DateTimeField(db_index=True, default=None, null=True),
        ),
        migrations.AlterField(
            model_name='action',
            name='action',
            field=models.TextField(choices=[('user_joined', 'User joined'), ('user_invited', 'User invited'), ('user_banned_bot', 'User banned by bot'), ('user_banned_subbot', 'User banned by subbot'), ('user_banned_user', 'User banned by user'), ('user_ban_failed', 'User ban failed'), ('user_leaved', 'User leaved'), ('detected_sub', 'Detected sub'), ('detected_invite', 'Detected invite'), ('detected_message', 'Detected message'), ('bot_invited_ext', 'Bot invited'), ('uhura_created_group', 'Uhura created group'), ('bot_banned', 'Bot banned'), ('user_deleted_bot', 'User deleted by bot'), ('user_deleted_sub', 'User deleted by subbot'), ('user_deleted_user', 'User deleted by user'), ('user_delete_failed', 'User delete failed'), ('user_granted_admin_rights', 'User granted admin rights'), ('user_lost_admin_rights', 'User lost admin rights'), ('user_unbanned_by_bot', 'User unbanned by bot')]),
        ),
        migrations.RunPython(fill_first_notified_from_email),
    ]
